// check test string for illegal characters as defined by illegal string
function hasIllegalCharacters( testStr, illegalStr )
{
   var isIllegal = false;
	var aChar = "";

	for( var index = 0; index < illegalStr.length; index++ )
	{
	   aChar = illegalStr.charAt( index );
		if( testStr.indexOf( aChar ) != -1 )
		{
		    isIllegal = true;
		}
	}
	
	return isIllegal;
}


// check test string for adjacent characters as defined by duplicate string
function checkForAdjacentDups( testStr, dupStr )
{
   var isAdjacent = false;
	var aChar = "";
	var testIndex;

	for( var dupIndex = 0; dupIndex < dupStr.length ; dupIndex++ )
	{
	   aChar = dupStr.charAt( dupIndex );
		
		for( var testIndex = 0; testIndex < ( testStr.length - 1 ); testIndex++ )
		{
		   if( testStr.charAt( testIndex ) == aChar && testStr.charAt( testIndex ) == testStr.charAt( testIndex + 1 ) )
		   {
		      isAdjacent = true;
				break;
		   }
		}
	}
	
	return isAdjacent;
}


// check test string for adjacent characters as defined by duplicate string
function checkForAdjacentChars( testStr )
{
   var isAdjacent = false;
	var atLocation = testStr.indexOf( '@' );

	if( atLocation < 1 )
	{
	   // the @ is in the first position so no more testing needed
		// avoids calling substring( ) with -1 as the start loction
      isAdjacent = true;
	}
	
	// create  short string of characters adjacent on either side of the @ symbol
	var shortStr = testStr.substring( atLocation - 1, atLocation + 2 );

   if( shortStr.indexOf( "." ) >= 0 )
	{
      // a period was found, so period and the @ are adjacent
      isAdjacent = true;
	}

	return isAdjacent;
}


// check email address for validity
function isEmailValid( formName, elementName )
{
   var emailOk  = true;
   var temp     = formName.elements[ elementName ];
   var atSymbol = temp.value.indexOf( '@' );
   var period   = temp.value.lastIndexOf( '.' );
   var space    = temp.value.indexOf( ' ' );
   var length   = temp.value.length - 1;   // Array is from 0 to length-1
	var illegal  = hasIllegalCharacters( temp.value, "!#$%^&*()/:;,+" );
	var adjChars = checkForAdjacentChars( temp.value );
	var dupChars = checkForAdjacentDups( temp.value, ".@" );

   if ( ( atSymbol < 1 ) ||                // '@' cannot be in first position
      ( period <= atSymbol + 1 ) ||        // must be at least one valid char btwn '@' and '.'
      ( period == length ) ||              // must be at least one valid char after '.'
      ( space  != -1 ) ||                  // no empty spaces permitted
      ( illegal == true ) ||               // no illegal characters
		( adjChars == true ) ||              // period and @ cannot be adjacent
		( dupChars == true ) )               // no adjacent . or @ characters
   {  
       emailOk = false;
       alert( 'Please enter a valid e-mail address!' );
       temp.focus( );
   }
	
   return emailOk;
}

// check required fields for entries
function checkFields( )
{
   var numRequiredFields = 4;
   var theForm = window.document.form1;
   var i;
   for( i = 0; i < numRequiredFields; ++i )
	 {
      if( theForm.elements[ i ].value == "" )
	    {
	       alert( "form incomplete" );
				 theForm.elements[ i ].focus( );
         return false;
	    }
	 }

   if( isEmailValid( "form1", "emailAddress" ) == false )
   {
      return false;
   }
	
	 return true;
}


