<?php
session_start( );

// encode strings to preserve spaces, single quotes and dashes
function encodeEntry( $str )
{
   htmlspecialchars( $str ); 
   $str = str_replace( " ", "&nbsp;", $str );
	$str = str_replace( "-", "&ndash;", $str );
	$str = str_replace( "'", "&quot;", $str );
	$str = str_replace( "\n", "<br>", $str );
	
	return $str;
}

// used with usort() to sort strings with no regard to case
function sortCaseInsensitive( $firstElement, $secondElement )
{
   if( strToUpper( $firstElement ) < strToUpper( $secondElement ) )
	{
	   return -1;
	}
	
	else if( strToUpper( $firstElement ) > strToUpper( $secondElement ) )
	{
	   return 1;
	}
	
	else
	{
	   return 0;
	}
}

// create a string of values for each entry
session_register( 'pageToEdit' );
$pageToEdit = $_SESSION[ 'pageToEdit' ];

// specify directory containing the users' directories
session_register( 'usersDir' );
$usersDir = $_SESSION[ 'usersDir' ];

// get the user name
session_register( 'userName' );
$userName = $_SESSION[ 'userName' ];

// create a string of values for each entry
$lastName = encodeEntry( $_REQUEST[ 'lastName' ] );
if( $lastName == "" )
{
   $lastName = " ";
}
$entryString = $lastName . "~";

$firstName = encodeEntry( $_REQUEST[ 'firstName' ] );
if( $firstName == "" )
{
   $firstName = " ";
}
$entryString = $entryString . $firstName . "~";

$middleName = encodeEntry( $_REQUEST[ 'middleName' ] );
if( $middleName == "" )
{
   $middleName = " ";
}
$entryString = $entryString . $middleName . "~";

$address1 = encodeEntry( $_REQUEST[ 'address1' ] );
if( $address1 == "" )
{
   $address1 = " ";
}
$entryString = $entryString . $address1 . "~";

$address2 = encodeEntry( $_REQUEST[ 'address2' ] );
if( $address2 == "" )
{
   $address2 = " ";
}
$entryString = $entryString . $address2 . "~";

$city = encodeEntry( $_REQUEST[ 'city' ] );
if( $city == "" )
{
   $city = " ";
}
$entryString = $entryString . $city . "~";

$state = encodeEntry( $_REQUEST[ 'state' ] );
if( $state == "" )
{
   $state = " ";
}
$entryString = $entryString . $state . "~";

$zip = encodeEntry( $_REQUEST[ 'zip' ] );
if( $zip == "" )
{
   $zip = " ";
}
$entryString = $entryString . $zip . "~";

$country = encodeEntry( $_REQUEST[ 'country' ] );
if( $country == "" )
{
   $country = " ";
}
$entryString = $entryString . $country . "~";

$hphone_ac = encodeEntry( $_REQUEST[ 'hphone_ac' ] );
if( $hphone_ac == "" )
{
   $hphone_ac = " ";
}
$entryString = $entryString . $hphone_ac . "~";

$hphone = encodeEntry( $_REQUEST[ 'hphone' ] );
if( $hphone == "" )
{
   $hphone = " ";
}
$entryString = $entryString . $hphone . "~";

$hphone_ext = encodeEntry( $_REQUEST[ 'hphone_ext' ] );
if( $hphone_ext == "" )
{
   $hphone_ext = " ";
}
$entryString = $entryString . $hphone_ext . "~";

$wphone_ac = encodeEntry( $_REQUEST[ 'wphone_ac' ] );
if( $wphone_ac == "" )
{
   $wphone_ac = " ";
}
$entryString = $entryString . $wphone_ac . "~";

$wphone = encodeEntry( $_REQUEST[ 'wphone' ] );
if( $wphone == "" )
{
   $wphone = " ";
}
$entryString = $entryString . $wphone . "~";

$wphone_ext = encodeEntry( $_REQUEST[ 'wphone_ext' ] );
if( $wphone_ext == "" )
{
   $wphone_ext = " ";
}
$entryString = $entryString . $wphone_ext . "~";

$cphone_ac = encodeEntry( $_REQUEST[ 'cphone_ac' ] );
if( $cphone_ac == "" )
{
   $cphone_ac = " ";
}
$entryString = $entryString . $cphone_ac . "~";

$cphone = encodeEntry( $_REQUEST[ 'cphone' ] );
if( $cphone == "" )
{
   $cphone = " ";
}
$entryString = $entryString . $cphone . "~";

$notes = encodeEntry( $_REQUEST[ 'notes' ] );
if( $notes == "" )
{
   $notes = " ";
}
$entryString = $entryString . $notes . "~";

$emailAddress = encodeEntry( $_REQUEST[ 'emailAddress' ] );
if( $emailAddress == "" )
{
   $emailAddress = " ";
}
$entryString = $entryString . $emailAddress . "~";

$type = $_REQUEST[ 'entryType' ];
$entryString = $entryString . $type;

session_register( 'dataFileName' );
$dataFileName = $_SESSION[ 'dataFileName' ];
$dataFile = "$usersDir/$userName/$dataFileName";

// open the file read-only.
$filePointer = fopen( $dataFile, "r" );

$index = 0;

// read entries from data file and put into array
while( ! feof( $filePointer ) )
{
   $tempStr = fgets( $filePointer );
	 
   if( $index == $pageToEdit )
	{
      // replace edited entry in the array
      $entryStr[] = "$entryString\n";
	}
	
	else
	{
	   $entryStr[] = $tempStr;
   }
	
	++$index;
}

fclose( $filePointer );

// sort entries before writing the array of entries back to the file
usort( $entryStr, "sortCaseInsensitive" );
reset( $entryStr );

// set up variables to determine the position of the saved string
//$len = strlen( $lastName );
$strPosition = 0;

// open the file to write.
$filePointer = fopen( $dataFile, "w+" );

foreach( $entryStr as $line )
{
   // write user sorted strings back to the data file
   fputs( $filePointer, $line );
}

fclose( $filePointer );
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>Personal Diary - Add an Entry</title>

<script type="text/javascript" language="JavaScript">
<!-- hide script from older browsers

setTimeout( "_onload( )", 500 );

// entry saved, display the edited page
function _onload( )
{
   document.location.replace( "PD_display.php?page=<?php echo $pageToEdit ?>" );
}

// end of hiding comment -->
</script>

</head>
<body bgcolor="#DCE9B1" onload="_onload( );">
<table width="100%" height="80%" align="center" cellspacing="0" cellpadding="2" border="0">
<tr>
    <td><h2 align="center">Entry is being saved to the phone book</h2></td>
</tr>
</table>
</body>
</html>

