<?php
/***********************************************************************************
* SCRIPT       : Xihuitl Calendar
* VERSION      : 1.0
* AUTHOR       : Ezequiel Alans Gzz.
* EMAIL        : chequelonmx@yahoo.com.mx
* WEBSITE      : http://www.ealanis.com
* DATE         : 04/13/2003
* COUNTRY      : Mxico
* COPYRIGHT    : This software is provided AS IS.
                 The author can not be held liable for any damage
                 that might arise from the use of this software.
                 Use it at your own risk.
                 All copyright notices and links to Author's website
                 MUST remain intact in the scripts and in the HTML
                 for the scripts.
* DESCRIPTION  : Calendar, Contacts and Notes
***********************************************************************************/

$aMonths = array("January","February","March","April","May","June","July","August","September","October","November","December");
$aDays = array("Su","Mo","Tu","We","Th","Fr","Sa");

function getMonthDays($mn,$yr) {
  switch($mn) {
    case 4: // Abr
    case 6: // Junio
    case 9: // Sept
    case 11: // Nov
      return(30);
      break;

    case 2: // Febrero
      return((date("L", mktime(0,0,0,1,1,$yr)))?29:28);
      break;

    default:
      return(31);
  }
}

// Funcin que dibuja el calendario de acuerdo a una fecha determinada de timestamp
function drawCalendar($dDate=0) {
  global $aDays;
  global $aMonths;

  $yearMaxValue = 2037;
  $yearMinValue = 1970;

  if(!$dDate) {
    // Dibujar el calendario para la fecha actual
    $dDate = time();
  }

  // Obtenemos da, mes, ao
  $dDa = date("j",$dDate);
  $dMo = date("n",$dDate);
  $dYr = date("Y",$dDate);

  // Tabla de Encabezados de Calendario
  echo "<form name='frmCal' method='POST' action='" . $_SERVER["PHP_SELF"] . "'>";
  echo "<table border='0' cellspacing='1' align='center' width='190' class='calendar'>";
  echo "<tr>";

  // Retroceso de Mes
  echo "<td>" .
    "<a href='" . $_SERVER["PHP_SELF"] . "?ts=" . mktime(0,0,0,$dMo-1,$dDa,$dYr) . "'>" .
    "<img src='img/arrowleft.gif' alt='Prev. Month' border='0' /></a></td>";
	
  // Mes
	echo "<td>" .
    "<select name='cboMonth' onChange=\"this.form.ts.value=" .
    "this.options[this.selectedIndex].value;this.form.submit();\">";

  for($i=1;$i<=12;$i++) {
    //echo "<option value='$i' ";
    echo "<option value='" . mktime(0,0,0,$i,$dDa,$dYr) . "' ";
    if($dMo == $i) {
      echo "SELECTED";
    }
    echo ">" . $aMonths[$i-1] . "</option>";
  }
  echo "</select></td></td>";

  // ComboBox del Ao
  echo "<td>";
  echo "<select name='cboYear' onchange=\"this.form.ts.value=" .
    "this.options[this.selectedIndex].value;this.form.submit();\">";
    
  for($i=$dYr-10;$i<$dYr+10;$i++) {
    if($i>=$yearMinValue && $i<=$yearMaxValue) {
      echo "<option value='" . mktime(0,0,0,$dMo,$dDa,$i) . "' ";
      if($dYr == $i) {
        echo "SELECTED";
      }
      echo ">$i</option>";
    }
  }
  echo "</select></td>";

  // Avance de Mes
  echo "<td>" .
    "<a href='" . $_SERVER["PHP_SELF"] . "?ts=" . mktime(0,0,0,$dMo+1,$dDa,$dYr) . "'>" .
    "<img src='img/arrowright.gif' alt='Next Month' border='0' /></a></td>";
  
  // Tabla de Ttulos de Das
   echo "</table><table border='0' cellspacing='0' width='190' class='calendar' align='center'>";
   echo "<tr>";
 	for($i=0;$i<7;$i++) {
    echo "<td>" . $aDays[$i] . "</td>";
  }

  echo "</tr></table>";
	// Tabla de Das
  echo "<table border='0' cellspacing='1' width='190' class='calendar' align='center'>";

  // Primer da del mes en la semana
  $weekDay = date("w",mktime(0,0,0,$dMo,1,$dYr));
  // Nmero de das en el mes
  $monthDays = getMonthDays($dMo,$dYr);
  
  $dayCount = 1;
  for($i=0;$i<42;$i++) {
    if($i%7==0)
      if($i==0)
        echo "<tr>";
      else
    	 echo "</tr><tr>";
  	if($i>=$weekDay && $dayCount<=$monthDays) {
      if($dayCount == $dDa) {
        echo "<td class='daySelected'>";
      } else {
        echo "<td class='dayNormal'>";
      }
      echo "<a href='" . $_SERVER["PHP_SELF"] . "?ts=" .
        mktime(0,0,0,$dMo,$dayCount,$dYr) . "'>" . $dayCount;
      echo "&nbsp;<img src='img/" . getDayEvents($dayCount,$dMo,$dYr) .
        ".gif' border='0' />";
      echo "</a></td>";
      $dayCount++;
    }
    else {
      echo "<td class='dayNormal'>&nbsp;</td>";
    }
  }
  echo "</tr>";
  echo "<input type='hidden' name='ts' />";
  echo "</table></form>";
  $now = time();
  echo "<table width='100%' border='0' align='center' cellpadding='0' cellspacing='0'>";
  echo "<tr><td align='rigth' width='72'>" .
    "<img src='img/puma.gif' border='0' alt='image' /></td>";
  echo "<td><b>Today is:</b> <br><a href='" . $_SERVER["PHP_SELF"] . "?ts=$now'>" . date("l, F j, Y",$now) . "</a>";
  echo "</tr></table>";
}

function getDayEvents($dDa,$dMo,$dYr) {
  $date = "$dYr-$dMo-$dDa";
  $sql = "SELECT apAllDay, apRepeat, HOUR(apStartHour) AS apStartTime, " .
    "DAYOFMONTH(apDate) AS apDay FROM tblappointments " .
    "WHERE apDate = '$date' " .
    "OR (apRepeat = 'W' AND (DAYOFWEEK('$date') = DAYOFWEEK(apDate) AND ('$date' >= apDate AND '$date' <= apRepUntil))) " .
    "OR (apRepeat = 'M' AND (DAYOFMONTH('$date') = DAYOFMONTH(apDate) AND('$date' >= apDate AND '$date' <= apRepUntil))) " .
    "OR (apRepeat = 'Y' AND ((MONTH('$date') = MONTH(apDate) AND DAYOFMONTH('$date') = DAYOFMONTH(apDate)) AND ('$date' >= apDate AND '$date' <= apRepUntil)))";
    
  // Conexin
  dbcnx() or exit("Can't connect to database");

  $result = mysql_query($sql)
    or exit("Error executing query " . mysql_error() . $sql);

  $daEvents = array("A" => 0,"M" => 0,"E" => 0);
  while($row = mysql_fetch_array($result)) {
    // da a marcar
    if($row["apAllDay"] == "T") {
      $daEvents["A"]=1;
      $daEvents["M"]=1;
      $daEvents["E"]=1;
    }
    elseif($row["apStartTime"]<12) {
      $daEvents["M"]=1;
    }
    else {
      $daEvents["E"]=1;
    }
  }
  return $daEvents["A"] . $daEvents["M"] . $daEvents["E"];
}

/*
function getMonthEvents($dMo,$dYr) {

  $sql = "SELECT apAllDay, apRepeat, HOUR(apStartHour) AS apStartTime, " .
    "DAYOFMONTH(apDate) AS apDay FROM tblappointments " .
    "WHERE MONTH(apDate) = '$dMo' AND YEAR(apDate) = '$dYr' " .
    "OR (apRepeat = 'W' AND ('$dYr-$dMo-1' >= apDate AND '$dYr-$dMo-" . getMonthDays($dMo,$dYr) . "' <= apRepUntil)) " .
    "OR (apRepeat = 'M' AND ('$dYr-$dMo-1' >= apDate AND '$dYr-$dMo-" . getMonthDays($dMo,$dYr) . "' <= apRepUntil)) " .
    "OR (apRepeat = 'Y' AND ('$dYr-$dMo-1' >= apDate AND '$dYr-$dMo-" . getMonthDays($dMo,$dYr) . "' <= apRepUntil))";

  echo $sql; 
  // Conexin
  dbcnx() or exit("Can't connect to database");
  
  $result = mysql_query($sql)
    or exit("Error executing query " . mysql_error() . $sql);
    
  $moEvents[1] = array("A" => 0,"M" => 0,"E" => 0);
  while($row = mysql_fetch_array($result)) {
    if(!isset($moEvents[$row["apDay"]])) {
      $moEvents[$row["apDay"]] = array("A" => 0,"M" => 0,"E" => 0);
    }

    // da a marcar
    $day = $row["apDay"];
    if($row["apAllDay"] == "T") {
      $moEvents[$day]["A"]=1;
      $moEvents[$day]["M"]=1;
      $moEvents[$day]["E"]=1;
    }
    elseif($row["apStartTime"]<12) {
      $moEvents[$day]["M"]=1;
    }
    else {
      $moEvents[$day]["E"]=1;
    }
    
    // Parche en caso de que haya repeticin semanal
    // se repite el evento mientras existan semanas en el mes
    if($row["apRepeat"]=="W") {
      $monthDays = getMonthDays($dMo,$dYr);
      $calcDay = $day+7;
      while($calcDay <= $monthDays) {
        $calcDay = date("j",mktime(0,0,0,$dMo,$calcDay,$dYr));
        $moEvents[$calcDay]["A"]=$moEvents[$day]["A"];
        $moEvents[$calcDay]["M"]=$moEvents[$day]["M"];
        $moEvents[$calcDay]["E"]=$moEvents[$day]["E"];
        $calcDay += 7;
      }
    }
  }
  return $moEvents;
}
*/

?>
